﻿// Procedure Loader Hide
#pragma TextEncoding = "UTF-8"
#pragma rtGlobals=3		// Use modern global access method and strict wave access.
#pragma hide=1

// uncomment to debug
//#define DEBUG

// ***
// HELPER FUNCTIONS

// draw tab1 - calibrate
Function disp_Tab1Draw(pwidth,pheight, ptabpos)
	variable pwidth, pheight, ptabpos

	variable tvoffset = ptabpos + 30
	variable tleft = 20
	
	TabControl tab_main, value=1, userdata(ptab)="1"
	
	// XY Scale
	
	TitleBox calxy_tab1,pos={tleft-8,tvoffset},size={84,22},title="XY Scale"
	TitleBox calxy_tab1,fSize=16,frame=0,fStyle=1,disable=1
	
	Button buttonclearlocalscale_tab1,pos={pwidth-280,tvoffset},size={86,16},title="Clear Local"
	Button buttonclearlocalscale_tab1,proc=X_ButtonProc,disable=1, help={"Clears local scale settings if they exist."}
	
	Button buttonclearglobalscale_tab1,pos={pwidth-180,tvoffset},size={86,16},title="Clear Global"
	Button buttonclearglobalscale_tab1,proc=X_ButtonProc,disable=1, help={"Clears global scale settings if they exist."}

	tvoffset += 24
	
	PopupMenu popupmethodxy_tab1,pos={20,tvoffset},size={113,23},title="How"
	PopupMenu popupmethodxy_tab1,mode=1,popvalue="pixel size",value= #"\"pixel size;image width;image height;\""
	PopupMenu popupmethodxy_tab1,disable=1,proc=X_PopMenuProc, help={"Define how the calibration scale should be applied.\rSettings are meters [m]."}
	
	SetVariable psizem_tab1, pos={11+150,tvoffset},size={83,16},title="[m]",format="%1.3f"
	SetVariable psizem_tab1, value=_NUM:1, limits={0.1,10,0.1}, disable=1, help={"Value in meters [m]."}
	SetVariable psizelm_tab1, pos={12+240,tvoffset-3},size={70,16},title="\[0x10\Sn\M"
	SetVariable psizelm_tab1, value=_NUM:1, limits={-10,10,1}, disable=1, help={"Exponent multiplier on factor 10."}
	
	Button buttonSetXY_tab1,pos={pwidth-85,tvoffset-5},size={75,25},proc=X_ButtonProc,title="Apply", disable=1

	tvoffset += 24
	
	CheckBox checkxyglobal_tab1,pos={pwidth-95,tvoffset+2},size={76,16},title="save as global",value=0, disable=1, help={"Save the settings as global to all images in this experiment."}

	// Intensity
	
	tvoffset += 24
	
	TitleBox rescale_tab1,pos={tleft-8,tvoffset},size={84,22},title="Intensity"
	TitleBox rescale_tab1,fSize=16,frame=0,fStyle=1,disable=1
			
	PopupMenu popupIonStack_tab1,pos={pwidth-110,tvoffset+4},size={100,23},title=""
	PopupMenu popupIonStack_tab1,mode=1,value="This Layer;Each Layer;All Layers;",disable=1
	
	tvoffset += 24
	
	PopupMenu popupmethodcalI_tab1,pos={tleft,tvoffset},size={113,23},title="How"
	PopupMenu popupmethodcalI_tab1,mode=1,popvalue="pixel size",value= #"\"Invert;Remove Negatives;Zero Outliers;Normalize Height;Normalize Flux Density;Equation;\""
	PopupMenu popupmethodcalI_tab1,disable=1,proc=X_PopMenuProc, help={"What should be done to the intensity."}

	SetVariable setvarfmax_tab1, title="f\Bmax", pos={tleft+200,tvoffset}, size={80,20}, value=_NUM:1, disable=1
	SetVariable setvarfmax_tab1, format="%2.2f",limits={0.01,1,0.1},fSize=12,help={"Outliers are taken as points above\rthis fraction of maximum in the image."}

	tvoffset += 24
	
	SetVariable setvarcalIEQN_tab1, pos={tleft,tvoffset+2},size={300,25},value=_STR:"",disable=1
	SetVariable setvarcalIEQN_tab1, help={"I - intensity; A - average intensity; x,y - position\rF,C - min,max intensity; R - RoI average"}
	Button buttonSetcalI_tab1,pos={pwidth-85,tvoffset-5},size={75,25},proc=X_ButtonProc,title="Apply", disable=1

	return 0
end

// update tab 1
Function disp_UpdateTab1()

	variable istack = f_IsStack()

	SetVariable setvarSize_tabM, win=$k_fullpanel, value=_STR:f_ImageSizeText()

	// ** Calibrate XY

	if (f_HasXYScale(0))		// global calibration exists
		Button buttonclearglobalscale_tab1, win=$k_fullpanel, disable=0
		Button buttonclearlocalscale_tab1, win=$k_fullpanel, disable=1
		Checkbox checkxyglobal_tab1, win=$k_fullpanel, disable=2
	elseif (f_HasXYScale(1))		// local calibration scale exists
		Button buttonclearglobalscale_tab1, win=$k_fullpanel, disable=1
		Button buttonclearlocalscale_tab1, win=$k_fullpanel, disable=0
		Checkbox checkxyglobal_tab1, win=$k_fullpanel, disable=0
	else
		Button buttonclearglobalscale_tab1, win=$k_fullpanel, disable=1
		Button buttonclearlocalscale_tab1, win=$k_fullpanel, disable=1
		Checkbox checkxyglobal_tab1, win=$k_fullpanel, disable=0
	endif				

	STRUCT S_CalibrateVariables scv
	Sf_RecallCalibrateVariables(scv)
	if (scv.xyhow!=0)
		PopupMenu popupmethodxy_tab1, win=$k_fullpanel, mode=scv.xyhow
		SetVariable psizem_tab1, win=$k_fullpanel, value=_NUM:scv.pivalue
		SetVariable psizelm_tab1, win=$k_fullpanel, value=_NUM:scv.pilog
	else
		SetVariable psizem_tab1, win=$k_fullpanel, value=_NUM:1
		SetVariable psizelm_tab1, win=$k_fullpanel, value=_NUM:0
	endif

	// ** Calibrate Intensity
	
	Sf_GetCalibrationInputs(scv)
	SetVariable setvarcalIEQN_tab1, win=$k_fullpanel, disable=(scv.ihow != 6)
	SetVariable setvarfmax_tab1, win=$k_fullpanel, disable=(scv.ihow != 3)
	PopupMenu popupiOnStack_tab1, win=$k_fullpanel, disable=(!istack)
	ControlInfo/W=$k_fullpanel popupmethodcalI_tab1
//	Button buttonSetcalI_tab1, win=$k_fullpanel, disable=(2*(v_value==1))
	
	return 0
end

// ***
// ACTIONS

// clear XY scale
Function T1_ClearXYScale(where)
	variable where
	
	// global values
	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile

	string iwf
	switch(where)
		case 0:		// global
			iwf = k_fullpackagefolder + ":" + k_pvfolder
			break
		case 1:		// local
			iwf = "root:" + cwdfolder + ":" + k_pvfolder
			break
	endswitch
	
	KillDataFolder/Z $iwf

	return 0
end

// set xy method
Function T1_SetXYMethod(how)
	variable how
	
//	PopupMenu mrulera_tab1, win=$k_fullpanel, disable = 1
	switch(how)
		case 4:	// ruler length
			PopupMenu mrulera_tab1, win=$k_fullpanel, disable = 0
			break
	endswitch
	return 0
end

// reset the xy calibration variables
Function T1_ResetXY()

	STRUCT S_CalibrateVariables scv
	if (Sf_RecallCalibrateVariables(scv)==-1)
		return 0
	endif
	
	T1_SetXY()
	
	return 0
	
end

// set the xy calibration
Function T1_SetXY()
	
	// global values
	DFREF pf = $k_fullpackageFolder
	SVAR/SDFR=pf cwdfolder, cwfile
	
	string swf = "root:" + cwdfolder
	wave/SDFR=$swf cwave = $cwfile
	
	variable iwpx, iw, asglobal
	variable pwidth = DimSize(cwave,0)
	variable pheight = DimSize(cwave,1)

	// get values from panel
	
	STRUCT S_CalibrateVariables scv
	Sf_GetCalibrationInputs(scv)
	switch(scv.xyhow)
		case 1:	// pixel size
			scv.mpp = scv.pivalue*10^scv.pilog
			scv.xyiwidth = pwidth*scv.mpp
			scv.xyiheight = pheight*scv.mpp
			break
		case 2:	// image width
			scv.xyiwidth = scv.pivalue*10^scv.pilog
			scv.mpp = scv.xyiwidth/pwidth
			scv.xyiheight = pheight*scv.mpp
			break
		case 3:	// image height
			scv.xyiheight = scv.pivalue*10^scv.pilog
			scv.mpp = scv.xyiheight/pheight
			scv.xyiwidth = pwidth*scv.mpp
			break
	endswitch
	// save values
	Sf_SaveCalibrateVariables(scv)

	return 0
end

// normalize the input to height
Static Function norm_byheight(wave theImg)

	variable scf
	
	WaveStats/Q theImg
	scf = 1/(V_max - V_min)
	MatrixOP/FREE theNImg = scf*(theImg - V_min)
	duplicate/O theNImg theImg
	
	return scf
end

// normalize the input to flux density
Static Function norm_byfluxdensity(wave theImg, variable isize)

	variable scf
	
	WaveStats/Q theImg
	scf = isize/V_sum
	MatrixOP/FREE theNImg = scf*theImg
	duplicate/O theNImg theImg
	
	return scf
end

// calibrate image intensity
Function T1_CalibrateIntensity() //(variable how)

	wave simg = f_imgwaveDisplayed()
	variable scf, iSize, bd = f_imageBitDepth()
	variable nplanes = f_NImagesInStack(), npl, ic
	variable isStack = f_isStack()
	variable scfmax = 2^bd - 1
	string wdfldr = f_wdfstr(0)
	string imgstr = f_wdfstr(1)
	string nimgstr
	string calcmd

	STRUCT S_CalibrateVariables scv
	Sf_GetCalibrationInputs(scv)
	
	DFREF cdf = GetDataFolderDFR()
	SetDataFolder $wdfldr
	
	switch(scv.ihow)
		case 1:	// invert
			if (isStack && (scv.ionstack == 1))
				ic = f_PlaneNumber()
				MatrixOP/FREE fplane = layer(simg,ic))
				ImageTransform/O invert fplane
				CopyScales simg fplane
				ImageTransform/P=(ic)/D=fplane setPlane simg
			else
				ImageTransform/O invert simg
			endif
			break

		case 2:	// remove negatives

			nimgstr = imgstr + "_rng"

			if (!isStack)
				duplicate/O simg $nimgstr
				wave nimg = $nimgstr
				nimg = nimg < 0 ? 0 : nimg[p][q]
			else
				// create new _rng as needed
				wave/Z rngimg = $nimgstr
				if (!WaveExists(rngimg))
					MatrixOP/O $nimgstr = simg
					wave rngimg = $nimgstr
					CopyScales simg rngimg
					rngimg = 0
				endif
				wave rngimg = $nimgstr
				switch(scv.ionstack)
					case 1:	// this layer
						npl = f_PlaneNumber()
						MatrixOP/O thePlane = layer(simg,npl)
						CopyScales simg thePlane
						thePlane = thePlane < 0 ? 0 : thePlane[p][q]
						ImageTransform/P=(npl)/D=rngimg setPlane thePlane					
						break
					case 2:	// each layer
					case 3:	// all layers
						MatrixOP/O theImg = simg
						for(ic=0;ic<nplanes;ic+=1)
							MatrixOP/O thePlane = layer(theImg,ic)
							thePlane = thePlane < 0 ? 0 : thePlane[p][q]
							ImageTransform/P=(ic)/D=thePlane setPlane theImg
						endfor
						CopyScales simg theImg
						duplicate/O theImg rngimg					
						break
				endswitch
			endif
			break
			
		case 3:	// zero outliers
		
			nimgstr = imgstr + "_zro"
			iSize = DimSize(simg,0)*DimSize(simg,1)

			if (!isStack)
				MatrixOP/O theImg = fp64(simg)
				zero_outliers(theImg, scv.fmax)
				CopyScales simg theImg
				duplicate/O theImg $nimgstr
				wave zroimg = $nimgstr
			else
				// create new _zro as needed
				wave/Z zroimg = $nimgstr
				if (!WaveExists(zroimg))
					MatrixOP $nimgstr = fp64(simg)
					wave zroimg = $nimgstr
					CopyScales simg zroimg
					zroimg = 0
				endif
				wave zroimg = $nimgstr
				
				switch(scv.ionstack)
					case 1:	// this layer
						npl = f_PlaneNumber()
						MatrixOP/O theImg = fp64(layer(simg,npl))
						zero_outliers(theImg, scv.fmax)
						CopyScales simg theImg
						ImageTransform/P=(npl)/D=theImg setPlane zroimg						
						break
					case 2:	// each layer
						MatrixOP/O theImg = fp64(simg)
						for(ic=0;ic<nplanes;ic+=1)
							MatrixOP/O thePlane = layer(theImg,ic)
							zero_outliers(thePlane, scv.fmax)
							ImageTransform/P=(ic)/D=thePlane setPlane theImg
						endfor
						CopyScales simg theImg
						duplicate/O theImg zroimg					
						break
					case 3:	// all layers
						MatrixOP/O theImg = fp64(simg)
						zero_outliers(theImg, scv.fmax)
						CopyScales simg theImg
						duplicate/O theImg zroimg	
						break
				endswitch
				killwaves/Z theImg, thePlane
			endif

			break
			
		case 4:	// normalize by height

			nimgstr = imgstr + "_nbh"

			if (!isStack)
				MatrixOP/O theImg = fp64(simg)
				norm_byheight(theImg)
				CopyScales simg theImg
				duplicate/O theImg $nimgstr
				wave nbhimg = $nimgstr
			else
				// create new _nbh as needed
				wave/Z nbhimg = $nimgstr
				if (!WaveExists(nbhimg))
					MatrixOP/O $nimgstr = fp64(simg)
					wave nbhimg = $nimgstr
					CopyScales simg nbhimg
					nbhimg = 0
				endif
				wave nbhimg = $nimgstr
				nplanes = f_NImagesInStack()
				switch(scv.ionstack)
					case 1:	// this layer
						npl = f_PlaneNumber()
						MatrixOP/O theImg = fp64(layer(simg,npl))
						norm_byheight(theImg)
						CopyScales simg theImg
						ImageTransform/P=(npl)/D=theImg setPlane nbhimg					
						break
					case 2:	// each layer
						MatrixOP/O theImg = fp64(simg)
						for(ic=0;ic<nplanes;ic+=1)
							MatrixOP/O thePlane = layer(theImg,ic)
							norm_byheight(thePlane)
							ImageTransform/P=(ic)/D=thePlane setPlane theImg
						endfor
						CopyScales simg theImg
						duplicate/O theImg nbhimg					
						break
					case 3:	// all layers
						MatrixOP/O theImg = fp64(simg)
						norm_byheight(theImg)
						CopyScales simg theImg
						duplicate/O theImg nbhimg					
						break
				endswitch
				killwaves/Z theImg, thePlane
			endif
			
			break

		case 5:	// normalize by flux density (total intensity)
		
			nimgstr = imgstr + "_nbf"
			iSize = DimSize(simg,0)*DimSize(simg,1)

			if (!isStack)
				MatrixOP/O theImg = fp64(simg)
				norm_byfluxdensity(theImg, isize)
				CopyScales simg theImg
				duplicate/O theImg $nimgstr
				wave nbfimg = $nimgstr
			else
				// create new _nbf as needed
				wave/Z nbfimg = $nimgstr
				if (!WaveExists(nbfimg))
					MatrixOP $nimgstr = fp64(simg)
					wave nbfimg = $nimgstr
					CopyScales simg nbfimg
					nbfimg = 0
				endif
				wave nbfimg = $nimgstr
				
				switch(scv.ionstack)
					case 1:	// this layer
						npl = f_PlaneNumber()
						MatrixOP/O theImg = fp64(layer(simg,npl))
						norm_byfluxdensity(theImg, isize)
						CopyScales simg theImg
						ImageTransform/P=(npl)/D=theImg setPlane nbfimg						
						break
					case 2:	// each layer
						MatrixOP/O theImg = fp64(simg)
						for(ic=0;ic<nplanes;ic+=1)
							MatrixOP/O thePlane = layer(theImg,ic)
							norm_byfluxdensity(thePlane, isize)
							ImageTransform/P=(ic)/D=thePlane setPlane theImg
						endfor
						CopyScales simg theImg
						duplicate/O theImg nbfimg					
						break
					case 3:	// all layers
						MatrixOP/O theImg = fp64(simg)/nplanes
						norm_byfluxdensity(theImg, isize)
						CopyScales simg theImg
						duplicate/O theImg nbfimg	
						break
				endswitch
				killwaves/Z theImg, thePlane
			endif
			break

		case 6:	// use an equation
		
			nimgstr = imgstr + "_eqn"
			calcmd = T1_getcalibrateIeqn(scv.ieqn)
			
			if (!isStack)
				MatrixOP/O tmpsrc = fp64(simg)
				duplicate/O tmpsrc tmpstck
				Execute/Q/Z calcmd
				CopyScales simg tmpstck
				duplicate/O tmpstck $nimgstr
				wave neqnimg = $nimgstr
			else
				// create new _neqn as needed
				wave/Z neqnimg = $nimgstr
				if (!WaveExists(neqnimg))
					MatrixOP $nimgstr = fp64(simg)
					wave neqnimg = $nimgstr
					CopyScales simg neqnimg
					neqnimg = 0
				endif
				wave neqnimg = $nimgstr
				nplanes = f_NImagesInStack()
				
				switch(scv.ionstack)
					case 1:	// this layer
						npl = f_PlaneNumber()
						MatrixOP/O tmpsrc = fp64(layer(simg,npl))
						duplicate/O tmpsrc tmpstck
						Execute/Q/Z calcmd
						CopyScales simg tmpstck
						ImageTransform/P=(npl)/D=tmpstck setPlane neqnimg						
						break
					case 2:	// each layer
						MatrixOP/O theImgStck = fp64(simg)
						for(ic=0;ic<nplanes;ic+=1)
							MatrixOP/O tmpsrc = layer(theImgStck,ic)
							duplicate/O tmpsrc, tmpstck
							Execute/Q/Z calcmd
							ImageTransform/P=(ic)/D=tmpstck setPlane tmpsrc
						endfor
						CopyScales simg tmpsrc
						duplicate/O tmpsrc neqnimg		
						break
					case 3:	// all layers
						MatrixOP/O tmpsrc = fp64(simg)
						duplicate/O tmpsrc, tmpstck
						Execute/Q/Z calcmd
						duplicate/O tmpstck neqnimg					
						break
				endswitch
			endif
			break
	endswitch
	killwaves/Z tmpsrc, tmpstck, theImgStck
	
	SetDataFolder cdf
	
	return 0
end

Static Function/S T1_getcalibrateIeqn(string strEQN)

	STRUCT S_ImgIntensities sii
	Sf_GetImgIntensities(sii)
	
	string rtstr = "", pstr
	
	rtstr = ReplaceString("A",strEQN,"A::")
	rtstr = ReplaceString("F",rtstr,"F::")
	rtstr = ReplaceString("C",rtstr,"C::")
	rtstr = ReplaceString("R",rtstr,"R::")
	rtstr = ReplaceString("x",rtstr,"x::")
	rtstr = ReplaceString("y",rtstr,"y::")
	rtstr = ReplaceString("I",rtstr,"I::")
	rtstr = ReplaceString("A::",rtstr,num2str(sii.iave),1)
	rtstr = ReplaceString("F::",rtstr,num2str(sii.imin),1)
	rtstr = ReplaceString("C::",rtstr,num2str(sii.imax),1)
	rtstr = ReplaceString("R::",rtstr,num2str(sii.roiave),1)
	rtstr = ReplaceString("x::",rtstr,"(pnt2x(tmpsrc,p))",1)
	rtstr = ReplaceString("y::",rtstr,"(pnt2x(tmpsrc,q))",1)
	rtstr = ReplaceString("I::",rtstr,"tmpsrc",1)
	sprintf rtstr, "tmpstck = %s", rtstr
	
	return rtstr
end

// zero outliers
Static Function zero_outliers(wave theImg, variable fmax)

	variable scf
	WaveStats/Q theImg
	scf = fmax*V_max
	theImg = theImg >= scf ? 0 : theImg
	return scf
end
